      Module MOD_SVP
      USE MOD_DONNEES, only: DP, msol, g, nomch => nom_chemin, zi
	IMPLICIT NONE
      PRIVATE
      PUBLIC :: initialize_SVP, g_rad_SVP, id_ppxi, C_ref, isotops

      Real(DP), Public :: grav, teff, mass

	integer, parameter                       :: pnchim = 50 , pzi=30
!
! igrad  (if =0 g_rad of unidentified elements will be set equal to zero)
!        (if =1 g_rad of unidentified elements will be set equal to -local_gravity)
! tgrad  (if =0 g_rad of identified elements will be set equal to zero)
!        (if =1 g_rad of identified elements will be set equal to -local_gravity)
!        (if =2 g_rad of identified elements will be set equal computed)
      integer, save  :: igrad = 1 , tgrad = 2      ! forced here

	integer, parameter                      :: nion_ppxi=30
	real(DP), dimension(0:nion_ppxi,pnchim) :: phistar,psistar
	real(DP), dimension(0:nion_ppxi,pnchim) :: xistar,alphstar
	real(DP), dimension(0:nion_ppxi,pnchim) :: acstar,betstar

	integer, dimension(pnchim)                     :: id_ppxi
	integer, dimension(pnchim,pnchim)              :: isotops

	character(Len=2), dimension(pnchim)           :: el_svp
	real(DP), dimension(pnchim)                   :: C_ref


	integer, dimension(0:pzi,pnchim)     :: niv_flag,niv_nb,niv_z
	integer, dimension(0:pzi,pnchim)     :: rar_flag
	real(DP), dimension(0:pzi,pnchim)    :: el_pot
	
	logical :: DEV=.true.
!	logical :: DEV=.false.

! Energy levels of ions: table(niveau,deg_ionisation,numero_element_cesam)

	integer, dimension(99,0:pzi,pnchim)  :: niv_g
	real(DP), dimension(99,0:pzi,pnchim) :: niv_e,niv_q


      CONTAINS
!===================================================================
      SUBROUTINE initialize_SVP(version)

      USE MOD_DONNEES, ONLY: DP, nchim, nom_elem, nucleo
      USE MOD_VARIABLES, ONLY : mtot => mstar , rtot => rstar

      IMPLICIT NONE

	character(64)           :: version

	print'(/,"Version of the SVP data: ",a,/)',TRIM(ADJUSTL(version))
	write(10,'(/,"Version of the SVP data: ",a,/)') TRIM(ADJUSTL(version))

      CALL sb_initsvp(mtot,nchim,nom_elem,nucleo,version)

      END SUBROUTINE initialize_SVP
!=======================================================================
      SUBROUTINE g_rad_SVP(ray,t,nel,grav,ychim,g_rad,dg_rad)

!	This subroutine computes radiative acceleration and derivatives
!     relative to abundances. It must be called for each layer and
!	each time atomic diffusion is computed.

! Inputs, for the layer:
!     ray: radius
!     t : temperature
!     nel : number of electrons per volume,
!     ychim : chemical composition per mole
!     grav : gravity

! Outputs
!     g_rad(i) : radiative acceleration
!     dg_rad(i,j) : derivative

!--------------------------------------------------------------

      USE MOD_DONNEES, ONLY: DP, nchim, nom_elem, nucleo
      USE MOD_VARIABLES, ONLY : mtot => mstar , rtot => rstar

      IMPLICIT NONE

      Real(DP), INTENT(in) :: ray, t, nel, grav
      Real(DP), INTENT(in), DIMENSION(:) :: ychim
      Real(DP), INTENT(out), DIMENSION(:,:) :: dg_rad
      Real(DP), INTENT(out), DIMENSION(:) :: g_rad

         call sb_g_rad2(nchim,nom_elem,nucleo,mtot,rtot,teff,
     +                     mass,ray,t,nel,ychim,g_rad,dg_rad)

      END SUBROUTINE g_rad_SVP
!=======================================================================

!=======================================================================
      Include "svp_codes.f"
!=======================================================================

      End Module MOD_SVP


